require "MF_ISMoodle"
require "TimedActions/ISBaseTimedAction"

TABAS_DrySelf = ISBaseTimedAction:derive("TABAS_DrySelf")

function TABAS_DrySelf:isValid()
    return true
end

function TABAS_DrySelf:waitToStart()
    if self.character:isCurrentState(ClimbOverFenceState.instance()) then
        return true
    end
    return self.character:shouldBeTurning()
end

function TABAS_DrySelf:update()
end

function TABAS_DrySelf:start()
    self.doDry = self.towel and self.character:getModData().bathingWetTimer > 0
    if self.doDry and not self.hasBTO then
        self:setActionAnim("TABAS_DryYourSelf")
        self:setOverrideHandModels(nil, self.towel)
        self.sound = self.character:playSound("FirstAidCleanBurn")
    end
end

function TABAS_DrySelf:stopSound()
    if self.sound and self.character:getEmitter():isPlaying(self.sound) then
        self.character:stopOrTriggerSound(self.sound)
    end
end

function TABAS_DrySelf:stop()
    self:stopSound()
    ISBaseTimedAction.stop(self)
end

function TABAS_DrySelf:perform()
    self:stopSound()
    local bWet = 70
    if self.doDry then
        if self.bathingWet ~= nil then
            self.bathingWet:setValue(0.5)
            self.character:getModData().bathingWetTimer = 0
        end
        if self.hasBTO then
            ISTimedActionQueue.add(BTO_WipeMySelf:new(self.character, self.towel, false, false, true, false, bWet))
        else
            self.character:getBodyDamage():setWetness(0)
            self.towel:setCurrentUsesFloat(0)
        end
    elseif self.bathingWet == nil then
        self.character:getModData().bathingWetTimer = 0
        self.character:getBodyDamage():setWetness(bWet)
    end

    ISBaseTimedAction.perform(self)
end

function TABAS_DrySelf:complete()
    return true
end

function TABAS_DrySelf:adjustMaxTime(maxTime)
    return maxTime
end

function TABAS_DrySelf:new(character, towel)
    local o = ISBaseTimedAction.new(self, character)
    setmetatable(o, self)
    self.__index = self
    o.towel = towel
    o.character = character
    o.doDry = false
    o.maxTime = 0
    if towel then
        o.hasBTO = towel and towel:hasTag("Wipeable")
        if not o.hasBTO  then
            o.maxTime = 160
        end
    end
    if MF then -- Moodle Framework
        o.bathingWet = MF.getMoodle("Wet_Bathing", character:getPlayerNum())
    end
    -- o.stopOnWalk = false
    o.ignoreHandsWounds = true
    return o
end